<?php

namespace App\Http\Controllers\Auth;

use App\Repositories\CategoryRepository;
use App\Repositories\ProductsRepository;
use App\Repositories\SettingsRepository;
use App\Repositories\ContentsRepository;
use App\Models\User;
use App\Models\RoleUser;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\RegistersUsers;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    protected $r_settingsAut;
    protected $r_categoriesAut;
    protected $r_contentsAut;
    protected $r_productsAut;
    protected $varsAut = array();

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = '/';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(SettingsRepository $settingsAut, CategoryRepository $categoriesAut, ContentsRepository $contentsAut, ProductsRepository $productsAut)
    {
        $this->middleware('guest')->except('logout');
        $this->r_settingsAut = $settingsAut;
        $this->r_categoriesAut = $categoriesAut;
        $this->r_contentsAut = $contentsAut;
        $this->r_productsAut = $productsAut;
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:6', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */
    protected function create(array $data)
    {
        /*return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);*/

        try {
            $user = User::create([
                'name' => $data['name'],
                'lastname' => $data['lastname'],
                'patronymic' => $data['patronymic'],
                'email' => $data['email'],
                'password' => Hash::make($data['password']),
            ]);
            $user->save();
            RoleUser::create([
                'user_id' => $user->id,
                'role_id' => 1
            ]);
            return $user;
        } catch (\Exception $e) {
            return log($e->getMessage());
        }
    }
    public function showRegistrationForm()
    {
        $title = 'Форма авторизации';
        $description = 'Форма авторизации для интернет-магазина';
        $settings = $this->getSettingsAut();
        $categories = $this->getCategoriesAut();
        $contentFooter = $this->getContentAut(2);
        $contentHeader = $this->getContentAut(3);
        $menu = array();
        foreach ($categories as $item) {
            if (empty($menu[$item->parentID])) {
                $menu[$item->parentID] = array();
            }
            array_push($menu[$item->parentID], $item);
        }
        $total = 0;
        if (session()->has('total')) {
            $total =  session()->get('total');
        }
        $wishCount = 0;
        if (session()->has('wishList')) {
            $wishCount = session()->get('wishCount');
        }
        $compareCount = 0;
        if (session()->has('compareCount')) {
            $compareCount = session()->get('compareCount');
        }
        $head = view('frontend.layouts.head')->with('title', $title)->with('description', $description)->render();
        $this->varsAut = array_add($this->varsAut, 'head', $head);
        $header = view('frontend.layouts.header')->with('menu', $menu)->with('contentHeader', $contentHeader)->with('wishCount', $wishCount)->with('compareCount', $compareCount)->with('total', $total)->render();
        $this->varsAut = array_add($this->varsAut, 'header', $header);
        $footer = view('frontend.layouts.footer')->with('settings', $settings)->with('contentFooter', $contentFooter)->render();
        $this->varsAut = array_add($this->varsAut, 'footer', $footer);
        return view('auth.register')->with($this->varsAut);
    }

    protected function getCategoriesAut()
    {
        $category = $this->r_categoriesAut->get();
        return $category;
    }

    protected function getSettingsAut()
    {
        $settings = $this->r_settingsAut->get();
        return $settings->first();
    }

    protected function getContentAut($id)
    {
        $content = $this->r_contentsAut->get()->find($id);
        return $content;
    }
}
