<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Repositories\CategoryRepository;
use App\Repositories\ProductsRepository;
use App\Repositories\SettingsRepository;
use App\Repositories\ContentsRepository;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    protected $r_settingsAut;
    protected $r_categoriesAut;
    protected $r_contentsAut;
    protected $r_productsAut;
    protected $varsAut = array();

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(SettingsRepository $settingsAut, CategoryRepository $categoriesAut, ContentsRepository $contentsAut, ProductsRepository $productsAut)
    {
        $this->middleware('guest')->except('logout');
        $this->r_settingsAut = $settingsAut;
        $this->r_categoriesAut = $categoriesAut;
        $this->r_contentsAut = $contentsAut;
        $this->r_productsAut = $productsAut;
    }

    public function showLoginForm()
    {
        $title = 'Форма авторизации';
        $description = 'Форма авторизации для интернет-магазина';
        $settings = $this->getSettingsAut();
        $categories = $this->getCategoriesAut();
        $menu = array();
        foreach ($categories as $item) {
            if (empty($menu[$item->parentID])) {
                $menu[$item->parentID] = array();
            }
            array_push($menu[$item->parentID], $item);
        }
        $total = 0;
        if (session()->has('total')) {
            $total =  session()->get('total');
        }
        $wishCount = 0;
        if (session()->has('wishList')) {
            $wishCount = session()->get('wishCount');
        }
        $compareCount = 0;
        if (session()->has('compareCount')) {
            $compareCount = session()->get('compareCount');
        }
        /*$head = view('frontend.layouts.head')->with('title', $title)->with('description', $description)->render();
        $this->varsAut = array_add($this->varsAut, 'head', $head);
        $header = view('frontend.layouts.header')->with('menu', $menu)->with('contentHeader', $contentHeader)->with('wishCount', $wishCount)->with('compareCount', $compareCount)->with('total', $total)->render();
        $this->varsAut = array_add($this->varsAut, 'header', $header);
        $footer = view('frontend.layouts.footer')->with('settings', $settings)->with('contentFooter', $contentFooter)->render();
        $this->varsAut = array_add($this->varsAut, 'footer', $footer);*/
        return view('auth.login')->with($this->varsAut);
    }

    protected function getCategoriesAut()
    {
        $category = $this->r_categoriesAut->get();
        return $category;
    }

    protected function getSettingsAut()
    {
        $settings = $this->r_settingsAut->get();
        return $settings->first();
    }

    protected function getContentAut($id)
    {
        $content = $this->r_contentsAut->get()->find($id);
        return $content;
    }

    protected function getProductIdAut($id)
    {
        $product = $this->r_productsAut->get()->find($id);
        return $product;
    }
}
