<?php

namespace App\Exceptions;

use App\Repositories\SectionsRepository;
use Exception;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array
     */
    protected $dontFlash = [
        'password',
        'password_confirmation',
    ];

    /**
     * Report or log an exception.
     *
     * @param  \Exception  $exception
     * @return void
     */
    public function report(Exception $exception)
    {
        parent::report($exception);
    }

    /**
     * Render an exception into an HTTP response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Exception  $exception
     * @return \Illuminate\Http\Response
     */
    public function render($request, Exception $exception)
    {
        if ($this->isHttpException($exception) && $exception->getStatusCode() == 404) {
            $contentHeader = $this->getSection('header');
            $contentHead = $this->getSection('contactHead');
            $contentMain = $this->getSection('error');
            $contentFooter = $this->getSection('footer');
            $tag = '404';
            $head = view('frontend.layouts.head')->with('contentHead', $contentHead)->render();
            $header = view('frontend.layouts.header')->with('contentHeader', $contentHeader)->with('tag', $tag)->render();
            $footer = view('frontend.layouts.footer')->with('contentFooter', $contentFooter)->render();
            $content = view('errors.content')->with('contentMain', $contentMain)->render();
            return response()->view('errors.404', [
                'head' => $head,
                'header' => $header,
                'footer' => $footer,
                'content' => $content
            ], 404);
        }
        return parent::render($request, $exception);
    }

    protected function getSection($section)
    {
        $r_section = new \App\Repositories\SectionsRepository(new \App\Models\Section);
        $section = $r_section->get('*', false, ['section', '=', $section]);
        if ($section != null) {
            return $section->first()->content;
        } else {
            return null;
        }
    }
}
